<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_enlightlite', language 'en'
 *
 * @package    theme_enlightlite
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author   LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['about'] = 'About';
$string['aboutustxt'] = 'About Us';
$string['autoslideshow'] = 'Auto play';
$string['autoslideshowdesc'] = 'Use this option to scroll slides automatically after page load.';
$string['bgcolor'] = 'Background Color';
$string['categories'] = "Categories";
$string['categoryimgheading'] = 'Category images';
$string['categoryimgheadingsub'] = 'USE IMAGES TO REPRESENT YOUR TOP LEVEL COURSE CATEGORIES';
$string['categoryimgdesc'] = 'This section will allow you to set images for each top level course categories. The Recommended image size width=360px and height=360px';
$string['categoryimgcategory'] = 'The image for the category: {$a->category}.';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><img class=img-polaroid src="enlightlite/pix/screenshot.jpg" /><h3>Theme Credits</h3><p><h3>Moodle Enlightlite theme</h3><p>This theme is based on the Bootstrapbase Moodle theme.</p><p><a href="http://getbootstrap.com">http://getbootstrap.com</a></p><p>Authors: LMSACE Dev Team<br>Contact: info@lmsace.com<br>Website: <a target="_blank" href="http://www.lmsace.com">www.lmsace.com</a><br></p>';
$string['configtitle'] = 'Enlightlite';
$string['copyright'] = 'Copyright content';
$string['copyrightdefault'] = 'Copyright &copy; 2017 - Developed by <a href="http://lmsace.com">LMSACE.com</a>. Powered by <a href="https://moodle.org">Moodle</a>';
$string['copyrightdesc'] = 'Enter the copyright information as plain text or lang:language_key for multi-lingual support (Ex <b>lang:information</b>). <br/>You can find the default language keys here : /theme/enlightlite/lang[FOLDER].';
$string['courses'] = 'Courses';
$string['courselayout'] = 'Course category layout';
$string['courselayoutdesc'] = 'To change the display format of the course category listing page choose any one of the custom layouts listed here, this will override layout of the course/index.php(i.e. coursecategory). Now the custom layout file will be used instead of the moodle\'s default layout.';
$string['customcss'] = 'Custom CSS';
$string['customcssdesc'] = 'Use this field to provide SCSS or CSS code which will be injected at the end of the style sheet.';
$string['enable'] = 'Enable';
$string['enlightlite_settings'] = "ENLIGHTLITE THEME SETTINGS";
$string['featuredcoursesheading'] = 'Featured Courses';
$string['footerblock'] = 'Footer Block';
$string['footerbtitledesc'] = 'Enter a title for this block as plain text or lang:language_key for multi-lingual support. You can find the theme language keys here: /theme/enlightlite/lang/en/theme_enlightlite.php';
 $string['footerdescription'] = 'A brief description in the context of the block title, for multi-lingual support enter lang:language_key.';
$string['footerbtitle1default'] = 'About us';
$string['footerbtitle2default'] = 'INFORMATION FOR';
$string['footerbtitle3default'] = 'QUICK LINKS';
$string['footerbtitle4default'] = 'CONTACT US';
$string['footerheading'] = 'Footer blocks';
$string['footerblink'] = 'Footer Block Link';
$string['footerblink1default'] = '<div><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut et lobortis diam.&nbsp;</p><p>Duis tellus enim, vestibulum eget varius id, vulputate et mi. Nullam feugiat, diam quis interdum varius</p></div><a href="#"><span style="color: #fff; font-weight: bold; border-bottom: 1px solid #fff">Start Learning Now</span></a>';
$string['footerblink2default'] = 'Future students|http://www.example.com/
International students |http://www.example.com/
Researchers|http://www.example.com/';
$string['footerblink3default'] = 'Accessibility|http://www.example.com/
Contact us|http://www.example.com/
Jobs|http://www.example.com/';
$string['footerblink_desc'] = 'You can configure Footer Block{$a->blockno} Links here to be shown by themes.Each line consists of some menu text (lang:language_key or just plain text) , a link URL separated by pipe characters. For example: <pre> lang:moodlecommunity|https://moodle.org
Moodle Support|https://moodle.org/support </pre>';
$string['frontpageheading'] = 'Marketing spots';
$string['layout'] = 'Layout';
$string['loginbg'] = 'Background image for login page';
$string['loginbgdesc'] = 'Upload a BG image for user login page. The Recommended image size width=1350px and height=650px';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Upload logo image for your website.<br> The image should be 50px high and any reasonable width (minimum:235px) that suits.';
$string['marketingspot'] = 'Marketing Spot';
$string['marketingspot1desc'] = 'Enter the Marketing Spot 1 block content either language key or text here.For ex: lang:display or Display';
$string['marketingspot2desc'] = 'Enter the Marketing Spot 2 block content either language key or text here.For ex: lang:display or Display';
$string['newcourses'] = 'New courses';
$string['numberofslides'] = 'Number of slides';
$string['numberofslidesdesc'] = 'Use this option to select the number of slides first and click the Save Changes button at the bottom of the settings page. After that the page will reload and you have options and textfields for the desired number of slides.';
$string['numberoftmonials'] = 'Number of testimonials';
$string['numberoftmonials_desc'] = 'Use this option to select the number of testimonials first and click the Save Changes button at the bottom of the settings page. After that the page will reload and you have options and textfields for the desired number of testimonials.';
$string['patternselect'] = 'Choose website color scheme';
$string['patternselectdesc'] = 'Select the color scheme you want to have for your site.';
$string['pluginname'] = 'Enlightlite';
$string['knowmore'] = 'Know More';
$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';
$string['signup'] = 'Sign up';
$string['slidecaption'] = 'Title (Slide #{$a->slide})';
$string['slidecaptiondefault'] = 'THE BEST SOLUTION';
$string['slidecaptiondesc'] = 'Enter the title for your slide as plain text or lang:language_key for multi-lingual support.
<br/>You can find the theme language keys here : /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['slideimage'] = ' Image (Slide #{$a->slide})';
$string['slideimagedesc'] = 'Upload the image you would like to display as the background image of the slide. The Recommended image size width=1600px and height=1080px ';
$string['slidedesc'] = ' Description(Slide #{$a->slide})';
$string['slidedesctext'] = 'Enter the description for your slide as plain text or lang:language_key for multi-lingual support.<br>
 You can find the theme language keys here: /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['slidedescdefault'] = 'Education on awesome unique moodle theme.';
$string['slideno'] = 'Slide #{$a->slide}';
$string['slidenodesc'] = 'Enter the settings for slide {$a->slide}.';
$string['slideStatus'] = ' Status (Slide #{$a->slide})';
$string['slideStatus_desc'] = 'Choose “Disable” if you don’t want to show this slide on homepage slider.';
$string["slideshowStatus"] = "Show homepage slider";
$string["slideshowStatus_desc"] = "Choose “No” if you don’t want an image slider on your home page.";
$string['enable'] = "Enable";
$string['disable'] = "Disable";
$string['slideshowdesc'] = 'The homepage slider will allow you to promote important elements of your site; you have to upload at least one slide image to make the slideshow appear. Slide title, description and button are optional. Use larger images for best results, the slider will crop your images to fit the height and width of the slideshow. If you use too small images it won’t work correctly.';
$string['slideinterval'] = 'Pause Time';
$string['slideintervaldesc'] = 'Use this option to set the pause or wait time between each slide change in the slideshow. Value is in milliseconds (i.e 1 second = 1000 milliseconds)';
$string['slideshowheading'] = 'Homepage slider';
$string['slideshowheadingsub'] = 'SLIDER OPTIONS';
$string['slideurl1'] = 'Button 1 URL';
$string['slideurl1desc'] = 'Use this option to set the link for first button of the slide.';
$string['slideurl2'] = 'Button 2 URL';
$string['slideurl2desc'] = 'Use this option to set the link for second button of the slide.';
$string["urltarget1"] = "Button 1 Target";
$string["urltarget2"] = "Button 2 Target";
$string["urltarget_desc"] = "Set this option to <i>New Window</i> if you want to open the URL in a new tab.";
$string["sameWindow"] = "Same Window";
$string["newWindow"] = "New Window";
$string['socialicon'] = 'Social Media Icon';
$string['socialicon1default'] = 'twitter';
$string['socialicon2default'] = 'google-plus';
$string['socialicon3default'] = 'pinterest-p';
$string['socialicon4default'] = 'facebook-f';
$string['siconbgc1default'] = '#47caf6';
$string['siconbgc2default'] = '#e84c3d';
$string['siconbgc3default'] = '#cd2129';
$string['siconbgc4default'] = '#3598dc';
$string['siconbgcdesc'] = 'Change the colours on the Social Media Icons Background color';
$string['siconurl'] = 'Social Media Icon Url';
$string['siconurl1default'] = 'https://twitter.com/yourtwittername';
$string['siconurl2default'] = 'https://www.google.com/+yourgoogleplusid';
$string['siconurl3default'] = 'https://in.pinterest.com/yourpinterestname/';
$string['siconurl4default'] = 'https://www.facebook.com/yourfacebookid';
$string['siconurldesc'] = 'The Social Media url of your organisation';
$string['socialicondesc'] = 'Enter the name of the icon you wish to use.  List is <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">here</a>. Just enter what is after the "fa-".';
$string['socialmediadesc'] = '<strong>This block contains social media icons</strong>';
$string['testimonial'] = 'Testimonial';
$string['testimonialno'] = 'Testimonial {$a->tmonial}';
$string['testimonialnodesc'] = 'Enter the settings for testimonial {$a->tmonial}.';
$string['tmonialheading'] = 'Testimonials';
$string['tmonialimg'] = 'User Image';
$string['tmonialimgdesc'] = 'The Recommended image size width=1350px and height=450px';
$string['tmonialtext'] = 'Testimonial';
$string['tmonialtext_default'] = 'We are building this curriculum with Enlightlite because we believe it reflects what developers everywhere should know.';
$string['tmonialtextdesc'] = '';
$string['tmonialuname'] = 'User Name';
$string['tmonialuname_default'] = 'Peter Lubbers';
$string['tmonialunamedesc'] = '';
$string['title'] = 'Title';
$string['themecolorsettings'] = 'Theme Colors';
$string['themegeneralsettings'] = 'General';
$string['toggletmonial'] = 'Testimonials display';
$string['toggletmonialdesc'] = 'If you wish to disable this block on front page, uncheck the checkbox <i>Activate this block</i>.';
$string['typography'] = 'Typography';
$string['url'] = 'Url';
$string['viewall'] = 'View all';
$string['loginheader'] = 'Login into your account';
$string['cmenushow'] = 'Enable courses mega menu';
$string['cmenushowdesc'] = 'Use this setting to show or hide the appearance of ”Courses Mega Menu” in primary menus.';
$string['links'] = 'Links';
$string['whatweoffer'] = 'What We Offer';
$string['courseexp'] = 'Course Experience';
$string['oursiteorg'] = 'Our Site for Organizations';
$string['helpfaq'] = 'Help and FAQ';
$string['feedbackprogram'] = 'Feedback Program';
$string['blog'] = 'Blog';
$string['meetups'] = 'Meetups';
$string['newsmedia'] = 'News & Media';
$string['about'] = 'About';
$string['jobs'] = 'Jobs';
$string['contactus'] = 'Contact Us';
$string['legal'] = 'Legal';
$string['information'] = 'Information';
$string['community'] = 'Community';
$string['ourorg'] = 'Our Organization';
$string['followuson'] = 'Follow us on';
$string['popularcourses'] = 'Popular Courses';
$string['newcourses'] = 'New Courses';
$string['seeallcourses'] = 'See all courses';
$string['slideurl1text'] = 'Button 1 Text';
$string['slideurl1textdesc'] = 'Use this option to set the text for first button of the slide. If you do not want to have button on your slide set this option to blank.<br> Enter the button text as plain text or lang:language_key for multi-lingual support.<br> You can find the theme language keys here: /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['slideurl2text'] = 'Button 2 Text';
$string['slideurl2textdesc'] = 'Use this option to set the text for second button of the slide. If you do not want to have button on your slide set this option to blank.<br> Enter the button text as plain text or lang:language_key for multi-lingual support.<br> You can find the theme language keys here: /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['mspottitledesc'] = 'Enter the block title as plain text or lang:language_key for multi-lingual support.<br> You can find the theme language keys here: /theme/enlightlite/lang/en/theme_enlightlite.php. <br/>You can find the default language keys here : /theme/enlightlite/lang[FOLDER].';
$string['mspotdescdesc'] = 'Enter the description as plain text or lang:language_key for multi-lingual support.<br> You can find the theme language keys here: /theme/enlightlite/lang/en/theme_enlightlite.php.';
$string['link'] = 'Link';
$string['text'] = 'Text';
$string['button'] = 'Button';
$string['target'] = 'Target';
$string['mspot2urldesc'] = 'Use this option to set the link for button.';
$string['mspot2urltxtdesc'] = 'Use this option to set the text for button. If you do not want to have button set this option to blank. Enter the button text as plain text or lang:language_key for multi-lingual support. You can find the theme language keys here: /theme/enlightlite/lang/en/theme_enlightlite.php';
$string['copyrightheading'] = 'Change copyright information';
$string['viewallcourses'] = 'View all Courses';
$string['aboutus'] = '<b>About</b> Us';
$string['aboutusdesc'] = 'Each of our courses will lead you towards a specific career. Companies do want just a college graduate anymore, they want employees with specific skill sets. An explosion of social media, new devices, such as tablets and smart phones, and increased Internet usage, companies are increasing their IT staff. In addition, many new businesses are seeking more programmers and designers. Data security concerns continue to grow. The field of Information Technology covers a wide range that includes database management, web development, system analysis, information security, and more. Job growth is estimated at 53 percent by 2018, according to the U.S. Department of Labor. Salaries in many IT jobs are expected to climb by 4 to 6 percent.';
$string['learnanytime'] = 'Learn anytime, anywhere';
$string['learnanytimedesc'] = 'Enjoy our free online courses, wherever you are and whenever you want. Access course content on mobile, tablet or desktop.';
$string['lavender'] = "Lavender";
$string['blue'] = "Blue";
$string['purple'] = "Purple";
$string['red'] = "Red";
$string['green'] = "Green";
$string['default'] = "Default";
$string['cat-placeholder'] = "Type the course name here...";
$string['primarymenu'] = "Primary menu items";
$string['primarymenudesc'] = "You can configure a primary menu here to be shown by themes. Each line consists of some menu text, a link URL (optional), a tooltip title (optional) and a language code or comma-separated list of codes (optional, for displaying the line to users of the specified language only), separated by pipe characters. Lines starting with a hyphen will appear as menu items in the previous top level menu, and dividers can be used by adding a line of one or more # characters where desired. <br>
For example: <br> Moodle community|https://moodle.org <br>
	-Moodle free support|https://moodle.org/support <br>
	-Moodle Docs|http://docs.moodle.org|Moodle Docs <br>
	-German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de <br>
	-### <br>
	-Moodle development|https://moodle.org/development <br>
	Moodle.com|http://moodle.com/ <br>";
$string['acourse_displaytype'] = 'Available courses display style';
$string['acourse_displaytypedesc'] = 'Select a display style for available courses listing.';
$string['categories_displaytype'] = 'Course categories display style';
$string['categories_displaytypedesc'] = 'Select a display style for course categories listing.';
$string['slider_type'] = 'Carousel';
$string['loadmore_type'] = 'Load more style';
$string['default_type'] = "Moodle default ";
$string['default_layout'] = "Moodle default layout";
$string["enlightlite_type"] = "Enlightlite theme custom style";
$string["custom_layout"] = "Custom layout";
$string['mycourse_displaytype'] = 'My courses display style';
$string['mycourse_displaytypedesc'] = 'Select a display style for my courses listing.';
$string['popularCourse_status'] = 'Show popular courses';
$string['popularCourse_statusdesc'] = 'Enable or disable popular courses block on front page.';
$string['marketingSpot1_status'] = 'Activate this block ';
$string['marketingSpot1_statusdesc'] = 'If you wish to disable this block on front page, uncheck the checkbox <i>Activate this block</i>.';
$string['footerb1_status'] = 'Footer Block1 Display Option';
$string['footerb1_statusdesc'] = 'If you wish to disable this block on footer section, uncheck the checkbox <i>Activate this block</i>.';
$string['footerb2_status'] = 'Footer Block2 Display Option';
$string['footerb2_statusdesc'] = '';
$string['footerb3_status'] = 'Footer Block3 Display Option';
$string['footerb3_statusdesc'] = '';
$string['footerb4_status'] = 'Footer Block4 Display Option';
$string['footerb4_statusdesc'] = '';
$string['tmonialTraversal_status'] = 'Show pagination';
$string['tmonialTraversal_statusdesc'] = '';
$string['mspotmediadesc'] = 'Insert an image or content.';
$string['media'] = 'Media';
$string['marketingspot1_content'] = '<div class="site-info"><div class="container"><div class="info-content"><div class="info-video"><video width="540px" controls><source src="" type="video/mp4"><source src="" type="video/ogg"></video></div><div class="info-block"><h2><b>About</b> Us</h2><p>Each of our courses will lead you towards a specific career. Companies do want just a college graduate anymore, they want employees with specific skill sets. An explosion of social media, new devices, such as tablets and smart phones, and increased Internet usage, companies are increasing their IT staff. In addition, many new businesses are seeking more programmers and designers. Data security concerns continue to grow. The field of Information Technology covers a wide range that includes database management, web development, system analysis, information security, and more.</p><div class="read-more"><a href="#">Read more</a></div></div><div class="clearfix"></div></div></div></div>';
$string['popularCourses_type'] = "Generate popular courses based on";
$string['popularCourse_typedesc'] = "Please choose your preferred criteria to generate popular courses.<br> 	If you choose custom courses option, you must mention the IDS of the courses you want to have on popular courses block in below setting.";
$string['popularCourses_id'] = "Popular courses IDS";
$string['popularCourse_iddesc'] = "Please enter the courses IDS separated by commas.";
$string['no_enrol'] = "Number of enrolled users";
$string['id_base'] = "Custom courses";
$string['left'] = "Left";
$string['right'] = "Right";
$string['center'] = 'Center';
$string['slidecontent'] = 'Content position (Slide #{$a->slide})';
$string['slidecontentdesc'] = "Use this option to set the location of slide title, description and button in the slide.";

$string["flash"] = "Flash";
$string["bounceIn"] = "BounceIn";
$string["bounceInDown"] = "BounceInDown";
$string["bounceInLeft"] = "BounceInLeft";
$string["bounceInRight"] = "BounceInRight";
$string["bounceInUp"] = "BounceInUp";
$string["fadeIn"] = "FadeIn";
$string["fadeInDown"] = "FadeInDown";
$string["fadeInDownBig"] = "FadeInDownBig";
$string["fadeInLeft"] = "FadeInLeft";
$string["fadeInLeftBig"] = "FadeInLeftBig";
$string["fadeInRight"] = "FadeInRight";
$string["fadeInRightBig"] = "FadeInRightBig";
$string["fadeInUp"] = "FadeInUp";
$string["fadeInUpBig"] = "FadeInUpBig";
$string["fadeOut"] = "FadeOut";
$string["flip"] = "Flip";
$string["flipInX"] = "FlipInX";
$string["flipInY"] = "FlipInY";
$string["flipOutX"] = "FlipOutX";
$string["flipOutY"] = "FlipOutY";
$string["lightSpeedIn"] = "LightSpeedIn";
$string["rotateIn"] = "RotateIn";
$string["rotateInDownLeft"] = "RotateInDownLeft";
$string["rotateInDownRight"] = "RotateInDownRight";
$string["rotateInUpLeft"] = "RotateInUpLeft";
$string["rotateInUpRight"] = "RotateInUpRight";
$string["slideInUp"] = "SlideInUp";
$string["slideInDown"] = "SlideInDown";
$string["slideInLeft"] = "SlideInLeft";
$string["slideInRight"] = "SlideInRight";
$string["zoom-In"] = "Zoom-In";
$string["zoomInDown"] = "ZoomInDown";
$string["zoomInLeft"] = "ZoomInLeft";
$string["zoomInRight"] = "ZoomInRight";
$string["zoomInUp"] = "ZoomInUp";
$string["hinge"] = "Hinge";
$string["rollIn"] = "RollIn";

$string["contentAnimate"] = 'Content animation (Slide #{$a->slide})';
$string["contentAnimatedesc"] = "Use this option to set an animation type for slide contents (i.e.  Slide title, description and button)";
$string["describtionAnimate"] = "Slide Caption Description Animation";
$string["describtionAnimatedesc"] = "Slider caption description";
$string["buttonAnimate"] = "Slide Caption Button Animation";
$string["buttonAnimatedesc"] = "buttonAnimatedesc";
$string["slideEffect"] = 'Slide animation';
$string["slideEffectdesc"] = "Use this option to set an animation type for slide transition.";
$string['random'] = 'Random';
$string['simpleFade'] = 'SimpleFade';
$string['curtainTopLeft'] = 'CurtainTopLeft';
$string['curtainTopRight'] = 'CurtainTopRight';
$string['curtainBottomLeft'] = 'CurtainBottomLeft';
$string['curtainBottomRight'] = 'CurtainBottomRight';
$string['curtainSliceLeft'] = 'CurtainSliceLeft';
$string['curtainSliceRight'] = 'CurtainSliceRight';
$string['blindCurtainTopLeft'] = 'BlindCurtainTopLeft';
$string['blindCurtainTopRight'] = 'BlindCurtainTopRight';
$string['blindCurtainBottomLeft'] = 'BlindCurtainBottomLeft';
$string['blindCurtainBottomRight'] = 'BlindCurtainBottomRight';
$string['blindCurtainSliceBottom'] = 'BlindCurtainSliceBottom';
$string['blindCurtainSliceTop'] = 'BlindCurtainSliceTop';
$string['stampede'] = 'Stampede';
$string['mosaic'] = 'Mosaic';
$string['mosaicReverse'] = 'MosaicReverse';
$string['mosaicRandom'] = 'MosaicRandom';
$string['mosaicSpiral'] = 'MosaicSpiral';
$string['mosaicSpiralReverse'] = 'MosaicSpiralReverse';
$string['topLeftBottomRight'] = 'TopLeftBottomRight';
$string['bottomRightTopLeft'] = 'BottomRightTopLeft';
$string['bottomLeftTopRight'] = 'BottomLeftTopRight';
$string['bottomLeftTopRight'] = 'BottomLeftTopRight';
$string['scrollLeft'] = 'ScrollLeft';
$string['scrollRight'] = 'ScrollRight';
$string['scrollHorz'] = 'ScrollHorz';
$string['scrollBottom'] = 'ScrollBottom';
$string['scrollTop'] = 'ScrollTop';



$string["slideOverlay"] = "Overlay opacity";
$string["slideOverlay_desc"] = "Use this option to set the opacity level,default value for this option is 0.4";
$string['backToTop_status'] = "Add back to top button";
$string['backToTop_statusdesc'] = "This option controls whether or not to enable a back to top button on your pages.";
$string["cmenuPosition"] = "Courses mega menu position";
$string["cmenuPosition_desc"] = "Use this setting to set position of the courses mega menu in primary menus.";
$string['name'] = "Name";
$string['sitenewsType'] = "Site news display style";
$string['sitenewsType_desc'] = "Select a display style for site news listing.";
$string["comboListboxType"] = 'Combo list display style';
$string["comboListboxType_desc"] = 'Select a display style for combo list block.';
$string['custom'] = "Custom";
$string["expand"] = "Expanded";
$string["collapse"] = "Collapsed";
$string["overlay_type"] = 'Overlay (Slide #{$a->slide})';
$string["overlaytype_desc"] = "Use this option to set an overlay for whole slide or slide content (i.e. Slide title, description and button). By this you will guarantee the readability of slide textual content.";
$string["for_slide"] = "for full slide";
$string["for_content"] = "only for slide content";
$string["none"] = "None";
$string["topLeft"] = "TopLeft";
$string["topCenter"] = "TopCenter";
$string["topRight"] = "TopRight";
$string["centerLeft"] = "CenterLeft";
$string["center"] = "Center";
$string["centerRight"] = "CenterRight";
$string["bottomLeft"] = "BottomLeft";
$string["bottomCenter"] = "BottomCenter";
$string["bottomRight"] = "BottomRight";
$string["slideheight"] = "Slideshow Height";
$string["slideheight_desc"] = "Use this option to set the height of the slideshow";
$string["slideCont_full"] = "Content Width";
$string["slideCont_fulldesc"] = "Use this option to set the content width for the slide. This width will be calculated as a percentage of main grid width. Default value for this option is 50%.";
$string["slideImgpos"] = "Slide image focus point";
$string["slideImgpos_desc"] = "Use this option to select the focus point of the slide image.";
$string["pagination"] = "Pagination";
$string["pagination_desc"] = "Use this option to set pagination styles in the slideshow.";
$string["dots"] = "Dots";
$string["dotThumb"] = "Dots & Thumbnails";
$string["thumbnails"] = "Thumbnails";
$string["pagi_none"] = "No Pagination";
$string['testiGeneral'] = "Testimonials general settings";
$string["testimonialsbg"] = "Background image for testimonial block";
$string["testimonialsbg_desc"] = "Upload an image for testimonial block background.  The Recommended image size width=1350px and height=350px";
$string["footbgimg"] = "Background image for footer section";
$string["footbgimg_desc"] = "Upload an image for footer section background. The Recommended image size width=1350px and height=350px";
$string["popularcoursesbg"] = "Background image for popular courses block";
$string["popularcoursesbg_desc"] = "Upload an image for popular courses block background.<br> The Recommended image size width=1350px and height=450px";
$string["testimonialsbg_type"] = "Background color options for testimonials block";
$string["testimonialsbg_typedesc"] = "Choose a background option you would like to have for testimonials block.";
$string["footbgimg_type"] = "Background color options for footer section";
$string["footbgimg_type_desc"] = "Choose a background option you would like to have for footer section.";
$string["popularcoursebg_type"] = "Background color options for popular courses block";
$string["popularcoursebg_typedesc"] = "Choose a background option you would like to have for popular courses block.";
$string["image"] = "Image";
$string["imagecolor"] = "Theme colour + Background image";
$string["imageparelex"] = "Image Parelex";
$string["imagecolor_parellax"] = "Image with overlay parellax";
$string["bgnone"] = "White background";
$string['overlay'] = "Theme colour";
$string["availablecoursesbg"] = "Background image for available courses block";
$string["availablecoursesbg_desc"] = "Upload an image for available courses block background.<br>The Recommended image size width=1350px and height=450px";
$string["availablecoursebg_type"] = "Background color options for available courses block";
$string["availablecoursebg_typedesc"] = "Choose a background option you would like to have for available courses block.";
$string["enrolledcoursesbg"] = "Background image for enrolled courses block";
$string["enrolledcoursesbg_desc"] = "Upload an image for course categories block background.<br>The Recommended image size width=1350px and height=450px";
$string["enrolledcoursebg_type"] = "Background color options for enrolled courses block";
$string["enrolledcoursebg_typedesc"] = "Choose a background option you would like to have for enrolled courses block.";
$string["categoriescoursesbg"] = "Background image for course categories block";
$string["categoriesbg_desc"] = "Upload an image for course categories block background.<br>The Recommended image size width=1350px and height=450px";
$string["categoriesbg_type"] = "Background color options for course categories block";
$string["categoriesbg_typedesc"] = "Choose a background option you would like to have for course categories block.";
$string['learntitle'] = "LEARN ANYTIME, ANYWHERE";
$string["marketingSpot2_status"] = "Activate this block ";
$string["marketingSpot2_statusdesc"] = ": If you wish to disable this block on front page, uncheck the checkbox <i>Activate this block</i>.";
$string['mspot2urltarget_desc'] = "Use this option to set the link target for button.";

$string["tmonialheadingsub_desc"] = "This section allows you to display user testimonials on front-page.";
$string['testimonialAutoplay'] = "Auto Play";
$string['testimonialAutoplay_desc'] = "";
$string['activateblock'] = "Activate this block";
$string["ourteamAutoplay"] = "OurTeam Autoplay";
$string["ourteamAutoplay_desc"] = "";
$string['ourteamTitle_desc'] = "";
$string["address"] = "Address";
$string['address_desc'] = "You may enter your address.";
$string["defaultaddress"] = "20-A , Nehru Street , Sathyamoorthi Nagar Madurai - 625010 , Tamilnadu , India.";
$string["emailid"] = "E-mail";
$string['email_desc'] = "You may enter your email.";
$string["defaultemailid"] = "yourmailid@example.com";
$string["phoneno"] = "Phone Number";
$string["defaultphoneno"] = "+123456789";
$string['footphone_desc'] = 'You may enter your phone number.';
$string['mspot1media'] = '<iframe src="https://www.youtube.com/embed/fNE7pyDyw3Y" allowfullscreen="" frameborder="0" height="391" width="545"></iframe>';
$string['footerdescription_desc'] = "A brief description in the context of the block title, for multi-lingual support enter lang:language_key.";
$string['search_courses'] = "Search Your Courses";
$string['seeprofile'] = "SEE PROFILE";
$string['typesearch'] = "Type and press Search";
$string['search'] = "Search";
$string["contentOverlay"] = 'ContentOverlay';
$string["sliderOverlay"] = 'SliderOverlay';
$string["textFillContent"] = 'TextFillContent';
$string["text_item_content"] = 'Text_item_content';
$string["double_heading_content"] = 'Double_heading_content';
$string['slideContentStyle_desc'] = 'Use this option to set the content style in the slide. <br>If you choose the content style as "Double title" you should mention the two titles on slide title option.<br>
The titles must be separated with pipe (|) , Ex : <i>Title1 | Title2</i>.';
$string['slideContentStyle'] = "Content style";
$string["importDemo"] = "Import demo content";
$string["importDemo_desc"] = "Please check the above box to import the demo data that will make your installation look like our <a href='http://www.lmsace.com/lab/m32/'>demo</a> site.<br> <b>WARNING!</b> Don’t install the sample data on your live existing website, unless it’s a fresh installation. <br> It may be possible that your current data get corrupted. We strongly recommend installing the sample data on a fresh Moodle installation. ";
$string["loginpageType"] = "Login page layout";
$string["loginpageType_desc"] = "Use this option to override the layout of the login page..";
$string["logintheme"] = "Enlightlite theme style";
$string['style'] = "Style";
$string['generallogo_menu'] = "COLOR SCHEMES, HEADER STYLES, LOGO & MENUS";
$string['managefrontpage_items'] = "MANAGE FRONT PAGE ITEMS";
$string['managebgimages'] = "MANAGE BACKGROUND IMAGES & COLOURS";
$string['miscellaneous'] = "MISCELLANEOUS ITEMS";

$string['slidecaption1default'] = "A RESPONSIVE EDUCATION FOCUSED MOODLE THEME";
$string['slidedesc1default'] = "Filled with features for a stunning school or university website";
$string['slidecaption2default'] = "The Best || MOODLE THEME FOR LMS";
$string['slidedesc2default'] = "Crafted for learning management system";
$string['slidecaption3default'] = "FULLY RESPONSIVE DESIGN";
$string['slidedesc3default'] = "Looks perfect on all mobile devices";
$string['readmore'] = "Read More";
$string['informationdesc'] = '<div><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut et lobortis diam.&nbsp;</p><p>Duis tellus enim, vestibulum eget varius id, vulputate et mi. Nullam feugiat, diam quis interdum varius</p></div><a href="#" style="color: #353535;">Start Learning Now</a>';

$string["contentOverlay"] = "Content overlay";
$string["sliderOverlay"] = "Fullslide overlay";
$string["doubleHeading"] = "Double title";
$string["themebased"] = "Plain theme colored";

$string["preloader_status"] = 'Enable preloader';
$string["preloader_statusdesc"] = 'This option allow you to show/hide preloader animation while opening the site pages.';
$string["preloaderbg_color"] = 'Preloader background color';
$string["preloaderbg_colordesc"] = 'Use this option to change the background color of the pre-loader page.';
$string["preloader"] = 'Preloader image';
$string["preloader_desc"] = ' Use this option to change the pre-loader animation image (GIF)';
$string['headerStyle'] = "Header Style";
$string['headerStyle_desc'] = "Use this option to set a header style for your site.";
$string['header'] = 'Style {$a->no} ';
$string["loaderStatus"] = "Show progress bar";
$string["loaderStatus_desc"] = "Use this option show / hide the progress bar.";
$string['primary_menu'] = "Home|#";
$string['footnote'] = "Footnote";
$string['privacy:metadata'] = 'The enlightlite theme does not store any personal data about any user.';
