/**
 * Javascript Module to handle filter buttons which appear above the tiles if used for format_tiles
 *
 * @module      format_tiles/filter_buttons
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since Moodle 3.3
 */
define("format_tiles/filter_buttons",["jquery"],(function($){var Selector_FILTER_BUTTON=".filterbutton",Selector_TILE=".tile",Selector_COLLAPSING=".tile-collapsing",Selector_COLLAPSED=".tile-collapsed",Selector_SPACER=".spacer",Selector_PAGE_CONTENT="#page-content",Selector_REGION_MAIN="#region-main",ClassNames_COLLAPSING="tile-collapsing",ClassNames_COLLAPSED="tile-collapsed",ClassNames_SELECTED="selected",Module_getPressedFilterButton=function(courseId,storageEnabled){return storageEnabled?localStorage.getItem("mdl-course-"+courseId+"-filter-btn"):null},Module_setPressedFilterButton=function(courseId,buttonId,storageEnabled){storageEnabled&&(0===buttonId?localStorage.removeItem("mdl-course-"+courseId+"-filter-btn"):localStorage.setItem("mdl-course-"+courseId+"-filter-btn",buttonId))},Module_unCollapseTiles=function(tileIds){tileIds.forEach((function(index,tileId){$("#tile-"+tileIds[tileId]).addClass(ClassNames_COLLAPSING).removeClass(ClassNames_COLLAPSED)})),setTimeout((function(){$(Selector_COLLAPSING).removeClass(ClassNames_COLLAPSING)}),300)},Module_collapseAllTiles=function(){$(Selector_TILE).not($(Selector_COLLAPSED)).not($(Selector_SPACER)).addClass(ClassNames_COLLAPSING),setTimeout((function(){$(Selector_COLLAPSING).addClass(ClassNames_COLLAPSED).removeClass(ClassNames_COLLAPSING)}),250)},Module_unCollapseAllTiles=function(){setTimeout((function(){$(Selector_COLLAPSED).addClass(ClassNames_COLLAPSING).removeClass(ClassNames_COLLAPSED),setTimeout((function(){$(Selector_COLLAPSING).removeClass(ClassNames_COLLAPSING)}),250)}),250)};return{init:function(courseId,storageEnabledLocal){$(document).ready((function(){var buttonAlreadyPressed=Module_getPressedFilterButton(courseId,storageEnabledLocal);if(buttonAlreadyPressed){var pressedButton=$("#filterbutton"+buttonAlreadyPressed);pressedButton||Module_setPressedFilterButton(courseId,buttonAlreadyPressed,0),$(Selector_FILTER_BUTTON).removeClass(ClassNames_SELECTED),pressedButton.addClass(ClassNames_SELECTED),Module_collapseAllTiles(),setTimeout((function(){Module_unCollapseTiles(JSON.parse(pressedButton.attr("data-sections")))}),250),Module_setPressedFilterButton(courseId,buttonAlreadyPressed,storageEnabledLocal)}var pageContent=$(Selector_PAGE_CONTENT);0===pageContent.length&&(pageContent=$(Selector_REGION_MAIN)),pageContent.on("click",Selector_FILTER_BUTTON,(function(e){var button=$(e.target),buttonId=button.attr("data-buttonid");"all"===buttonId||Module_getPressedFilterButton(courseId,storageEnabledLocal)===buttonId?(Module_collapseAllTiles(),setTimeout((function(){Module_unCollapseAllTiles()}),500),$(Selector_FILTER_BUTTON).removeClass(ClassNames_SELECTED),Module_setPressedFilterButton(courseId,0,storageEnabledLocal),$("#filterbutton-all").addClass(ClassNames_SELECTED)):($(Selector_FILTER_BUTTON).removeClass(ClassNames_SELECTED),button.addClass(ClassNames_SELECTED),Module_collapseAllTiles(),setTimeout((function(){Module_unCollapseTiles(JSON.parse(button.attr("data-sections")))}),250),Module_setPressedFilterButton(courseId,buttonId,storageEnabledLocal))}))}))}}}));

//# sourceMappingURL=filter_buttons.min.js.map