function _typeof(obj){return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj},_typeof(obj)
/**
 * Javascript Module to handle rendering of course modules (e.g. resource/PDF, resource/html, page) in modal windows
 *
 * When the user clicks a PDF course module subtile or old style resource
 * if we are using modals for it (e.g. PDF) , create, populate, launch and size the modal
 *
 * @module      format_tiles/course_mod_modal
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since       Moodle 3.3
 */}define("format_tiles/course_mod_modal",["jquery","core/modal_factory","core/config","core/templates","core/notification","core/ajax"],(function($,modalFactory,config,Templates,Notification,ajax){var loadingIconHtml,courseId,modalStore={},win=$(window),Selector={completioncheckbox:".completioncheckbox",completionAuto:".completion-auto",modal:".modal",modalDialog:".modal-dialog",modalBody:".modal-body",sectionMain:".section.main",pageContent:"#page-content",regionMain:"#region-main",completionState:"#completion-check-",cmModalClose:".embed_cm_modal .close",cmModal:".embed_cm_modal",moodleMediaPlayer:".mediaplugin_videojs",urlModalLoadWarning:"#embed-url-error-msg-",closeBtn:"button.close",ACTIVITY:"li.activity",URLACTIVITYPOPUPLINK:".activity.modtype_url.urlpopup a",newWindowButton:".button_expand",modalHeader:".modal-header",embedModuleButtons:".embed-module-buttons",iframe:"iframe"},CLASS_COMPLETION_ENABLED="completion-enabled",CLASS_COMPLETION_MANUAL="completion-manual",CLASS_COMPLETION_CHECK_BOX="completioncheckbox",LaunchModalDataActions={launchResourceModal:"launch-tiles-resource-modal",launchModuleModal:"launch-tiles-module-modal",launchUrlModal:"launch-tiles-url-modal"},COMPLETION_TOGGLE_TYPES_MANUAL_NOT_DONE="manual:mark-done",COMPLETION_TOGGLE_TYPES_MANUAL_DONE="manual:undo",modalMinWidth=function(){return Math.min(win.width(),1100)},stopAllVideosOnDismiss=function(modal){modal.find(Selector.iframe).length>0&&modal.find(Selector.closeBtn).click((function(e){$(e.currentTarget).closest(Selector.cmModal).find(Selector.iframe).each((function(index,iframe){(iframe=$(iframe)).attr("src",iframe.attr("src"))}))})),modal.find("object").length>0&&modal.find(Selector.closeBtn).click((function(e){var modal=$(e.currentTarget).closest(Selector.cmModal);modal.find("object").each((function(index,object){(object=$(object)).attr("data","")})),modalStore[modal.attr("data-cmid")]=void 0})),modal.find(Selector.moodleMediaPlayer).length>0&&(modal.find(Selector.closeBtn).click((function(){modal.find(Selector.moodleMediaPlayer).html("")})),modalStore[modal.attr("data-cmid")]=void 0)},resizeModal=function(modalRoot){modalRoot.find(Selector.modal).animate({"max-width":modalMinWidth()},"fast");var mediaPlayer=$(Selector.moodleMediaPlayer);mediaPlayer.find("div").each((function(index,child){$(child).css("max-width","")})),mediaPlayer.length>0&&stopAllVideosOnDismiss(modalRoot),modalRoot.find(Selector.iframe).each((function(index,iframe){var modal;0===(modal=modalRoot.find(Selector.modalDialog)).length&&(modal=modalRoot.find(Selector.modal));var iframeWidth=Math.min($(iframe).width(),win.width());iframeWidth>modal.width()-70&&(modal.animate({"max-width":Math.max(iframeWidth+70,modalMinWidth())},"fast"),modalRoot.find(Selector.modal).animate({"max-width":Math.max(iframeWidth+70,modalMinWidth())},"fast"));var iframeHeight=Math.min($(iframe).height(),win.height()),modalBody=modalRoot.find(Selector.modalBody);iframeHeight>modalBody.height()-70&&modalBody.animate({"min-height":Math.min(iframeHeight+70,win.height())+1},"fast"),stopAllVideosOnDismiss(modalRoot)}))},modalHeightChangeWatcher=function modalHeightChangeWatcher(modalRoot,howManyChecks,duration){var oldHeight=arguments.length>3&&void 0!==arguments[3]?arguments[3]:0,iframe=modalRoot.find(Selector.modalBody);if(iframe){var newHeight=Math.round(iframe.height());newHeight&&newHeight>oldHeight+10&&resizeModal(modalRoot),howManyChecks>0&&setTimeout((function(){modalHeightChangeWatcher(modalRoot,howManyChecks-1,duration,newHeight)}),duration)}},renderModalHeader=function(clickedCmObject,modalRoot,pluginfileUrl,showDownload,showNewWindow){var sectionNum=clickedCmObject.closest(Selector.sectionMain).attr("data-section"),templateData={cmid:clickedCmObject.attr("data-cmid"),activityname:clickedCmObject.attr("data-title"),tileid:sectionNum};if(clickedCmObject.hasClass(CLASS_COMPLETION_ENABLED)){templateData.istrackeduser=1,templateData.hascompletion=1;var oldState="1"===clickedCmObject.attr("data-completion-state");templateData.overallcomplete=oldState?1:0,templateData.overallincomplete=oldState?0:1,templateData.completionIsManual=clickedCmObject.hasClass(CLASS_COMPLETION_MANUAL),templateData.completionIsManual?clickedCmObject.attr("toggle-manual-completion",templateData.overallcomplete?COMPLETION_TOGGLE_TYPES_MANUAL_DONE:COMPLETION_TOGGLE_TYPES_MANUAL_NOT_DONE):(templateData.statuscomplete=templateData.overallcomplete,templateData.statusincomplete=templateData.overallincomplete),templateData.showDownload=void 0!==showDownload?showDownload:0,templateData.showNewWindow=void 0!==showNewWindow?showNewWindow:0,templateData.pluginfileUrl=pluginfileUrl,templateData.forModal=!0,oldState!==templateData.completionstate&&require(["format_tiles/completion"],(function(completion){completion.triggerCompletionChangedEvent(parseInt(sectionNum),parseInt(clickedCmObject.attr("data-cmid")))}))}Templates.render("format_tiles/embed_module_modal_header_btns",templateData).done((function(html){modalRoot.find(Selector.embedModuleButtons).remove(),modalRoot.find($("button.close")).remove(),modalRoot.find(Selector.modalHeader).append(html),modalRoot.find(Selector.closeBtn).detach().appendTo(modalRoot.find(Selector.embedModuleButtons));modalRoot.find('[data-action="toggle-manual-completion"]').on("click",(function(){require(["format_tiles/completion"],(function(completion){setTimeout((function(){completion.triggerCompletionChangedEvent(parseInt(modalRoot.attr("data-section")),parseInt(modalRoot.attr("data-cmid")))}),300)}))}))})).fail(Notification.exception),setTimeout((function(){modalHeightChangeWatcher(modalRoot,3,1e3)}),500)};return{init:function(courseIdInit,isEditing){courseId=courseIdInit,$(document).ready((function(){var modalSelectors=Object.keys(LaunchModalDataActions).map((function(key){return'[data-action="'+LaunchModalDataActions[key]+'"]'})).join(", "),pageContent=$(Selector.pageContent);0===pageContent.length&&(pageContent=$(Selector.regionMain)),pageContent.on("click",modalSelectors,(function(e){var tgt=$(e.target);if(!tgt.hasClass(CLASS_COMPLETION_CHECK_BOX)&&!tgt.parent().hasClass(CLASS_COMPLETION_CHECK_BOX)){e.preventDefault();var currTgt=$(e.currentTarget),clickedCmObject=currTgt.closest("li.activity");if(clickedCmObject.hasClass("completeonview")){var sectionNum=clickedCmObject.closest(Selector.sectionMain).attr("data-section"),cmid=clickedCmObject.attr("data-cmid");require(["format_tiles/completion"],(function(completion){completion.triggerCompletionChangedEvent(sectionNum?parseInt(sectionNum):0,cmid?parseInt(cmid):0)}))}var existingModal=modalStore[clickedCmObject.attr("data-cmid")];if("object"===_typeof(existingModal))existingModal.show();else switch(ajax.call([{methodname:"format_tiles_log_mod_view",args:{courseid:courseId,cmid:clickedCmObject.attr("data-cmid")}}])[0].fail(Notification.exception),currTgt.attr("data-action")){case LaunchModalDataActions.launchModuleModal:!function(clickedCmObject){var cmid=clickedCmObject.attr("data-cmid"),methodName="format_tiles_get_mod_"+clickedCmObject.attr("data-modtype")+"_html";modalFactory.create({type:modalFactory.types.DEFAULT,title:clickedCmObject.attr("data-title"),body:loadingIconHtml}).done((function(modal){modalStore[cmid]=modal,modal.setLarge(),modal.show();var modalRoot=$(modal.root);modalRoot.attr("data-cmid",cmid),modalRoot.attr("data-section",clickedCmObject.closest(Selector.sectionMain).attr("data-section")),modalRoot.attr("id","embed_mod_modal_"+cmid),modalRoot.addClass("embed_cm_modal"),modalRoot.addClass("mod_"+clickedCmObject.attr("data-modtype")),stopAllVideosOnDismiss(modalRoot),ajax.call([{methodname:methodName,args:{courseid:courseId,cmid:cmid}}])[0].done((function(response){return renderModalHeader(clickedCmObject,modalRoot,"",!1,!1),modal.setBody(response.html),!0})).fail((function(ex){!0!==config.developerdebug?window.location=config.wwwroot+"/mod/"+clickedCmObject.attr("data-modtype")+"/view.php?id="+cmid:Notification.exception(ex)}))}))}(clickedCmObject);break;case LaunchModalDataActions.launchResourceModal:!function(clickedCmObject){var cmid=clickedCmObject.attr("data-cmid");modalFactory.create({type:modalFactory.types.DEFAULT,title:clickedCmObject.attr("data-title"),body:loadingIconHtml}).done((function(modal){modalStore[cmid]=modal,modal.setLarge(),modal.show();var modalRoot=$(modal.root);modalRoot.attr("id","embed_mod_modal_"+cmid),modalRoot.attr("data-cmid",cmid),modalRoot.attr("data-section",clickedCmObject.closest(Selector.sectionMain).attr("data-section")),modalRoot.addClass("embed_cm_modal");var sectionNum=clickedCmObject.closest(Selector.sectionMain).attr("data-section"),templateData={id:cmid,pluginfileUrl:clickedCmObject.attr("data-url"),objectType:"text/html",width:"100%",height:Math.round(win.height()-60),cmid:cmid,tileid:sectionNum,isediting:0,sesskey:config.sesskey,activityname:clickedCmObject.attr("data-title"),config:{wwwroot:config.wwwroot},showDownload:0,showNewWindow:0,hascompletion:0,completionstring:""};return"resource_pdf"===clickedCmObject.attr("data-modtype")&&(templateData.objectType="application/pdf"),Templates.render("format_tiles/embed_file_modal_body",templateData).done((function(html){modal.setBody(html),modalRoot.find(Selector.modalBody).animate({"min-height":Math.round(win.height()-60)},"fast"),"resource_html"===clickedCmObject.attr("data-modtype")?(modalRoot.find(Selector.modal).animate({"max-width":"100%"},"fast"),modalRoot.find(Selector.modalDialog).animate({"max-width":"100%"},"fast"),modalRoot.find(Selector.modalBody).animate({"max-width":"100%"},"fast"),stopAllVideosOnDismiss(modalRoot)):(modalRoot.find(Selector.modal).animate({"max-width":modalMinWidth()},"fast"),modalRoot.find(Selector.modalDialog).animate({"max-width":modalMinWidth()},"fast"))})).fail(Notification.exception),renderModalHeader(clickedCmObject,modalRoot,templateData.pluginfileUrl,!0,!0),!0}))}(clickedCmObject);break;case LaunchModalDataActions.launchUrlModal:!function(clickedCmObject){var cmid=clickedCmObject.attr("data-cmid");modalFactory.create({type:modalFactory.types.DEFAULT,title:clickedCmObject.attr("data-title"),body:loadingIconHtml}).done((function(modal){modalStore[cmid]=modal,modal.setLarge(),modal.show();var modalRoot=$(modal.root);modalRoot.attr("id","embed_mod_modal_"+cmid),modalRoot.attr("data-cmid",cmid),modalRoot.attr("data-section",clickedCmObject.closest(Selector.sectionMain).attr("data-section")),modalRoot.addClass("embed_cm_modal");var modalWidth=Math.round(.9*win.width()),modalHeight=Math.round(.9*win.height()),sectionNum=clickedCmObject.closest(Selector.sectionMain).attr("data-section"),templateData={id:cmid,pluginfileUrl:clickedCmObject.attr("data-url"),objectType:"text/html",width:modalWidth-30,height:modalHeight-30,cmid:cmid,tileid:sectionNum,isediting:0,sesskey:config.sesskey,activityname:clickedCmObject.attr("data-title"),config:{wwwroot:config.wwwroot},secondaryurl:clickedCmObject.closest(Selector.ACTIVITY).attr("data-url-secondary")};return Templates.render("format_tiles/embed_url_modal_body",templateData).done((function(html){modal.setBody(html),modalRoot.find(Selector.modalBody).animate({"min-height":modalHeight},"fast"),modalRoot.find(Selector.modal).animate({"max-width":modalWidth},"fast"),modalRoot.find(Selector.modalDialog).animate({"max-width":modalWidth},"fast"),modalRoot.find(Selector.modalBody).animate({"max-width":modalWidth},"fast"),stopAllVideosOnDismiss(modalRoot),modalRoot.find(Selector.modalBody).addClass("text-center")})).fail(Notification.exception),renderModalHeader(clickedCmObject,modalRoot,templateData.pluginfileUrl,!1,!0),setTimeout((function(){modalRoot.find(Selector.newWindowButton).click((function(){modalStore[modalRoot.attr("data-cmid")].hide(),modalStore[modalRoot.attr("data-cmid")]=void 0,modalRoot.remove(),$(".modal-backdrop").not("#window-overlay").removeClass("show").addClass("hide")}))}),1e3),!0}))}(clickedCmObject);break;default:throw new Error("Unknown modal type "+currTgt.attr("data-action"))}if(0!==clickedCmObject.find(Selector.completionAuto).length){var _sectionNum=clickedCmObject.closest(Selector.sectionMain).attr("data-section"),_cmid=clickedCmObject.attr("data-cmid");require(["format_tiles/completion"],(function(completion){completion.triggerCompletionChangedEvent(_sectionNum?parseInt(_sectionNum):0,_cmid?parseInt(_cmid):0)}))}}})),Templates.render("format_tiles/loading",{}).catch(Notification.exception).done((function(html){loadingIconHtml=html})).fail(Notification.exception),isEditing||pageContent.on("click",Selector.URLACTIVITYPOPUPLINK,(function(e){!function(e){var clickedActivity=$(e.currentTarget).closest(Selector.ACTIVITY);void 0!==clickedActivity.attr("data-url")&&(e.stopPropagation(),e.preventDefault(),ajax.call([{methodname:"format_tiles_log_mod_view",args:{courseid:courseId,cmid:clickedActivity.attr("data-cmid")}}])[0].done((function(){var sectionNum=clickedActivity.closest(Selector.section).attr("data-section"),cmid=clickedActivity.attr("data-cmid");require(["format_tiles/completion"],(function(completion){completion.triggerCompletionChangedEvent(sectionNum?parseInt(sectionNum):0,cmid?parseInt(cmid):0)})),window.open(clickedActivity.attr("data-url"))})).fail(Notification.exception))}(e)})),$(document).on("format-tiles-completion-changed",(function(e,data){data.cmid&&modalStore[data.cmid]&&(modalStore[data.cmid]=void 0)}))}))}}}));

//# sourceMappingURL=course_mod_modal.min.js.map